/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.admin;

import filenet.vw.apps.admin.images.VWImageLoader;
import filenet.vw.apps.admin.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.result.IVWAdminMenuUpdateEventListener;
import filenet.vw.toolkit.admin.result.VWAdminMenuUpdateEvent;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.search.VWAdminSearchPane;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.RepaintManager;
import javax.swing.ToolTipManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class VWAdminCore
extends VWBaseCore
implements IVWAdminMenuUpdateEventListener,
ActionListener {
    private static final double s_dividerLocation = 0.7;
    private static final String s_adminSearchPaneClassName = "filenet.vw.toolkit.admin.search.VWAdminSearchPane";
    private static final String s_adminResultPaneClassName = "filenet.vw.toolkit.admin.result.VWAdminResultPane";
    private VWSplitPane m_rootSplitPane = null;
    private int m_iDividerLocation = 0;
    private VWAdminSearchPane m_searchPane = null;
    private VWAdminResultPane m_resultsPane = null;
    private JMenuBar m_menuBar = null;
    private JMenu m_fileMenu = null;
    private JMenuItem m_lockItem = null;
    private JMenuItem m_unlockItem = null;
    private JMenuItem m_unlockAllItem = null;
    private JMenuItem m_saveItem = null;
    private JMenuItem m_saveAllItem = null;
    private JMenuItem m_discardItem = null;
    private JMenuItem m_discardAllItem = null;
    private JMenuItem m_openTrackerItem = null;
    private JMenuItem m_openStepProcessorItem = null;
    private JMenuItem m_pageSetupItem = null;
    private JMenuItem m_printItem = null;
    private JMenuItem m_exportItem = null;
    private JMenuItem m_exitItem = null;
    private JMenu m_editMenu = null;
    private JMenuItem m_fieldValuesItem = null;
    private JMenuItem m_findNowItem = null;
    private JMenuItem m_newSearchItem = null;
    private JMenu m_viewMenu = null;
    private JCheckBoxMenuItem m_searchPaneItem = null;
    private JCheckBoxMenuItem m_resultsPaneItem = null;
    private JMenuItem m_nextSetItem = null;
    private JMenuItem m_showHideColumnsItem = null;
    private JMenuItem m_refreshItem = null;
    private JMenuItem m_infoStackItem = null;
    private JMenu m_tasksMenu = null;
    private JMenuItem m_manageAttachmentsItem = null;
    private JMenuItem m_manageWFGroupsItem = null;
    private JMenuItem m_manageTrackersItem = null;
    private JMenuItem m_assignReassignWorkItem = null;
    private JMenuItem m_returnWorkItem = null;
    private JMenuItem m_completeWorkItem = null;
    private JMenuItem m_deleteWorkItem = null;
    private JMenuItem m_terminateWorkItem = null;
    private JMenuItem m_recoveryItem = null;
    private JMenuItem m_outOfOfficeItem = null;
    private JMenu m_helpMenu = null;
    private JMenuItem m_aboutItem = null;
    private JMenuItem m_contentsItem = null;

    public void init(VWSessionInfo sessionInfo) {
        try {
            Locale browserLocale = sessionInfo.getBrowserLocale();
            if (browserLocale != null) {
                sessionInfo.getSession().setClientLocale(browserLocale);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        try {
            VWDefaultSessionProxy.setSession(sessionInfo.getSession());
            RepaintManager repaintManager = RepaintManager.currentManager(sessionInfo.getParentContainer());
            if (!repaintManager.isDoubleBufferingEnabled()) {
                repaintManager.setDoubleBufferingEnabled(true);
            }
            super.init(sessionInfo);
            this.initApplicationPane(sessionInfo);
            super.performInitialRefresh();
            ToolTipManager.sharedInstance().setDismissDelay(100000);
        }
        catch (Throwable t) {
            VWDebug.logException(new Exception(t));
        }
    }

    public void destroy() {
        this.performExitItemAction(false);
    }

    public boolean exitApp() {
        boolean bExitingApp = true;
        if (this.m_resultsPane != null) {
            boolean bCanceled = this.m_resultsPane.setSession(null, true);
            if (bCanceled) {
                bExitingApp = false;
            } else if (this.m_searchPane != null) {
                this.m_searchPane.setSession(null);
                this.m_searchPane = null;
            }
        }
        return bExitingApp;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_exitItem) {
            this.performExitItemAction(true);
        } else if (object == this.m_lockItem) {
            this.m_resultsPane.performLockAction();
        } else if (object == this.m_saveItem) {
            this.m_resultsPane.performSaveAction(false);
        } else if (object == this.m_saveAllItem) {
            this.m_resultsPane.performSaveAction(true);
        } else if (object == this.m_discardItem) {
            this.m_resultsPane.performCancelAction(false);
        } else if (object == this.m_discardAllItem) {
            this.m_resultsPane.performCancelAction(true);
        } else if (object == this.m_unlockItem) {
            this.m_resultsPane.performUnlockAction(false);
        } else if (object == this.m_unlockAllItem) {
            this.m_resultsPane.performUnlockAction(true);
        } else if (object == this.m_fieldValuesItem) {
            this.m_resultsPane.performEditFieldsAction();
        } else if (object == this.m_findNowItem) {
            this.m_searchPane.performFindNow();
        } else if (object == this.m_newSearchItem) {
            this.m_searchPane.performNewSearch();
        } else if (object == this.m_searchPaneItem) {
            this.performViewSearchPaneAction();
        } else if (object == this.m_resultsPaneItem) {
            this.performViewResultsPaneAction();
        } else if (object == this.m_nextSetItem) {
            this.m_resultsPane.performNextSetAction();
        } else if (object == this.m_showHideColumnsItem) {
            this.m_resultsPane.performShowHideColumnsAction();
        } else if (object == this.m_manageTrackersItem) {
            this.m_resultsPane.performManageTrackersAction();
        } else if (object == this.m_manageWFGroupsItem) {
            this.m_resultsPane.performManageWFGroupsAction();
        } else if (object == this.m_assignReassignWorkItem) {
            this.m_resultsPane.performAssignReassignWorkAction();
        } else if (object == this.m_returnWorkItem) {
            this.m_resultsPane.performReturnWorkAction();
        } else if (object == this.m_deleteWorkItem) {
            this.m_resultsPane.performDeleteWorkAction();
        } else if (object == this.m_terminateWorkItem) {
            this.m_resultsPane.performTerminateWorkAction();
        } else if (object == this.m_completeWorkItem) {
            this.m_resultsPane.performCompleteWorkAction();
        } else if (object == this.m_infoStackItem) {
            this.m_resultsPane.performInformationStackAction();
        } else if (object == this.m_refreshItem) {
            this.m_resultsPane.performRefreshAction();
        } else if (object == this.m_openTrackerItem) {
            this.m_resultsPane.performOpenItemAction(0);
        } else if (object == this.m_openStepProcessorItem) {
            this.m_resultsPane.performOpenItemAction(1);
        } else if (object == this.m_printItem) {
            this.m_resultsPane.performPrintAction(true);
        } else if (object == this.m_pageSetupItem) {
            this.m_resultsPane.performPageSetupAction();
        } else if (object == this.m_exportItem) {
            this.m_resultsPane.performExportAction();
        } else if (object == this.m_recoveryItem) {
            this.m_resultsPane.performRecoveryAction();
        } else if (object == this.m_outOfOfficeItem) {
            this.m_resultsPane.performOutOfOfficeAction();
        } else if (object == this.m_aboutItem) {
            this.performAboutItemAction();
        } else if (object == this.m_contentsItem) {
            this.performContentsItemAction();
        } else {
            super.actionPerformed(event);
        }
    }

    public void enableDisableMenuOptions(VWAdminMenuUpdateEvent e) {
        this.m_searchPaneItem.setEnabled(true);
        this.m_resultsPaneItem.setEnabled(true);
        this.m_pageSetupItem.setEnabled(true);
        this.m_fieldValuesItem.setEnabled(e.getEditFields());
        this.m_nextSetItem.setEnabled(e.getNextSet());
        this.m_infoStackItem.setEnabled(e.getInformationStack());
        this.m_refreshItem.setEnabled(e.getRefresh());
        this.m_openTrackerItem.setEnabled(e.getOpenTracker());
        this.m_openStepProcessorItem.setEnabled(e.getOpenStepProcessor());
        this.m_printItem.setEnabled(e.getPrint());
        this.m_exportItem.setEnabled(e.getExportFile());
        this.m_showHideColumnsItem.setEnabled(e.getShowHideColumns());
        this.m_lockItem.setEnabled(e.getLock());
        this.m_unlockItem.setEnabled(e.getUnlock());
        this.m_saveItem.setEnabled(e.getSave());
        this.m_discardItem.setEnabled(e.getCancel());
        this.m_assignReassignWorkItem.setEnabled(e.getAssignReassignWork());
        this.m_returnWorkItem.setEnabled(e.getReturnWork());
        this.m_deleteWorkItem.setEnabled(e.getDeleteWork());
        this.m_terminateWorkItem.setEnabled(e.getTerminateWork());
        this.m_completeWorkItem.setEnabled(e.getComplete());
        this.m_manageTrackersItem.setEnabled(e.getManageTrackers());
        this.m_manageWFGroupsItem.setEnabled(e.getManageWFGroups());
        this.m_unlockAllItem.setEnabled(e.getUnlockAll());
        this.m_saveAllItem.setEnabled(e.getSaveAll());
        this.m_discardAllItem.setEnabled(e.getCancelAll());
        this.m_recoveryItem.setEnabled(e.getRecovery());
        this.m_outOfOfficeItem.setEnabled(e.getOutOfOffice());
        if (this.m_vwSessionInfo == null || this.m_vwSessionInfo.getSession() == null) {
            this.m_findNowItem.setEnabled(false);
            this.m_newSearchItem.setEnabled(false);
        } else {
            this.m_findNowItem.setEnabled(true);
            this.m_newSearchItem.setEnabled(true);
        }
    }

    private void initApplicationPane(VWSessionInfo sessionInfo) {
        Container parentContainer = sessionInfo.getParentContainer();
        parentContainer.setLayout(new BorderLayout());
        this.initMenuBar();
        try {
            this.m_searchPane = (VWAdminSearchPane)Beans.instantiate(this.getClass().getClassLoader(), s_adminSearchPaneClassName);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error: cannot find class filenet.vw.toolkit.admin.search.VWAdminSearchPane");
        }
        catch (IOException e) {
            System.err.println("Error: cannot load class filenet.vw.toolkit.admin.search.VWAdminSearchPane");
        }
        try {
            this.m_resultsPane = (VWAdminResultPane)Beans.instantiate(this.getClass().getClassLoader(), s_adminResultPaneClassName);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error: cannot find class filenet.vw.toolkit.admin.result.VWAdminResultPane");
        }
        catch (IOException e) {
            System.err.println("Error: cannot load class filenet.vw.toolkit.admin.result.VWAdminResultPane");
        }
        this.m_rootSplitPane = new VWSplitPane(0, this.m_searchPane, this.m_resultsPane);
        this.m_rootSplitPane.setOneTouchExpandable(true);
        this.m_rootSplitPane.setDividerLocation(0.7);
        this.m_rootSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("lastDividerLocation")) {
                    JSplitPane jsp = (JSplitPane)e.getSource();
                    int dl = jsp.getDividerLocation();
                    if (dl > VWAdminCore.this.m_rootSplitPane.getMaximumDividerLocation()) {
                        if (VWAdminCore.this.m_iDividerLocation == 0) {
                            VWAdminCore.this.m_iDividerLocation = jsp.getLastDividerLocation();
                        }
                    } else if (dl < VWAdminCore.this.m_rootSplitPane.getMinimumDividerLocation()) {
                        if (VWAdminCore.this.m_iDividerLocation == 0) {
                            VWAdminCore.this.m_iDividerLocation = jsp.getLastDividerLocation();
                        }
                    } else {
                        VWAdminCore.this.m_iDividerLocation = dl;
                    }
                }
            }
        });
        sessionInfo.getParentContainer().add((Component)this.m_rootSplitPane, "Center");
        if (this.m_searchPane != null) {
            this.m_searchPane.init(sessionInfo.getParentFrame());
            this.m_searchPane.setSession(sessionInfo.getSession());
        }
        if (this.m_resultsPane != null) {
            this.m_resultsPane.setSession(sessionInfo.getSession(), false);
            this.m_resultsPane.setMainContainer(sessionInfo.getParentContainer());
            this.m_resultsPane.setParentFrame(sessionInfo.getParentFrame());
            this.m_resultsPane.setParentApplet(sessionInfo.getParentApplet());
        }
        if (this.m_resultsPane != null && this.m_searchPane != null) {
            this.m_searchPane.addPerformSearchListener(this.m_resultsPane);
        }
        if (this.m_resultsPane != null) {
            this.m_resultsPane.addMenuUpdateEventListener(this);
        }
    }

    private void initMenuBar() {
        JMenu settingsMenu;
        this.m_menuBar = new JMenuBar();
        if (this.m_menuBar != null && this.m_menuBar.getMenuCount() > 0) {
            this.m_menuBar.removeAll();
        }
        this.initFileMenuItems();
        this.initFileMenu();
        if (this.m_fileMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_fileMenu);
        }
        this.initEditMenuItems();
        this.initEditMenu();
        if (this.m_editMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_editMenu);
        }
        this.initViewMenuItems();
        this.initViewMenu();
        if (this.m_viewMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_viewMenu);
        }
        this.initTasksMenuItems();
        this.initTasksMenu();
        if (this.m_tasksMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_tasksMenu);
        }
        if ((settingsMenu = this.getSettingsMenu(this.m_menuBar)) != null) {
            this.m_menuBar.add(settingsMenu);
        }
        this.initHelpMenuItems();
        this.initHelpMenu();
        if (this.m_helpMenu.getMenuComponentCount() > 0) {
            this.m_menuBar.add(this.m_helpMenu);
        }
        this.m_vwSessionInfo.getParentRootPane().setJMenuBar(this.m_menuBar);
        this.enableDisableMenuOptions(new VWAdminMenuUpdateEvent(this));
        this.m_viewMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                int dl = VWAdminCore.this.m_rootSplitPane.getDividerLocation();
                if (dl > VWAdminCore.this.m_rootSplitPane.getMaximumDividerLocation()) {
                    VWAdminCore.this.m_searchPaneItem.setSelected(true);
                    VWAdminCore.this.m_resultsPaneItem.setSelected(false);
                    VWAdminCore.this.m_searchPaneItem.setEnabled(false);
                    VWAdminCore.this.m_resultsPaneItem.setEnabled(true);
                } else if (dl < VWAdminCore.this.m_rootSplitPane.getMinimumDividerLocation()) {
                    VWAdminCore.this.m_resultsPaneItem.setSelected(true);
                    VWAdminCore.this.m_searchPaneItem.setSelected(false);
                    VWAdminCore.this.m_resultsPaneItem.setEnabled(false);
                    VWAdminCore.this.m_searchPaneItem.setEnabled(true);
                } else {
                    VWAdminCore.this.m_resultsPaneItem.setSelected(true);
                    VWAdminCore.this.m_searchPaneItem.setSelected(true);
                    VWAdminCore.this.m_resultsPaneItem.setEnabled(true);
                    VWAdminCore.this.m_searchPaneItem.setEnabled(true);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
    }

    private void initFileMenuItems() {
        this.m_fileMenu = VWStringUtils.getMenuUsingString(VWResource.s_fileMenu_withHK);
        VWAccessibilityHelper.setAccessibility(this.m_fileMenu, this.m_menuBar, this.m_fileMenu.getText(), this.m_fileMenu.getText());
        this.m_lockItem = VWStringUtils.getMenuItemUsingString(VWResource.s_lock_withHK);
        this.m_lockItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_lockItem, this.m_fileMenu, this.m_lockItem.getText(), this.m_lockItem.getText());
        this.m_unlockItem = VWStringUtils.getMenuItemUsingString(VWResource.s_unlock_withHK);
        this.m_unlockItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_unlockItem, this.m_fileMenu, this.m_unlockItem.getText(), this.m_unlockItem.getText());
        this.m_unlockAllItem = VWStringUtils.getMenuItemUsingString(VWResource.s_unlockAll_withHK);
        this.m_unlockAllItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_unlockAllItem, this.m_fileMenu, this.m_unlockAllItem.getText(), this.m_unlockAllItem.getText());
        this.m_saveItem = VWStringUtils.getMenuItemUsingString(VWResource.s_saveChanges_withHK);
        this.m_saveItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_saveItem, this.m_fileMenu, this.m_saveItem.getText(), this.m_saveItem.getText());
        this.m_saveAllItem = VWStringUtils.getMenuItemUsingString(VWResource.s_saveAllChanges_withHK);
        this.m_saveAllItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_saveAllItem, this.m_fileMenu, this.m_saveAllItem.getText(), this.m_saveAllItem.getText());
        this.m_discardItem = VWStringUtils.getMenuItemUsingString(VWResource.s_discardChanges_withHK);
        this.m_discardItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_discardItem, this.m_fileMenu, this.m_discardItem.getText(), this.m_discardItem.getText());
        this.m_discardAllItem = VWStringUtils.getMenuItemUsingString(VWResource.s_discardAllChanges_withHK);
        this.m_discardAllItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_discardAllItem, this.m_fileMenu, this.m_discardAllItem.getText(), this.m_discardAllItem.getText());
        this.m_infoStackItem = VWStringUtils.getMenuItemUsingString(VWResource.s_infoStackItem_withHK);
        this.m_infoStackItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_infoStackItem, this.m_fileMenu, this.m_infoStackItem.getText(), this.m_infoStackItem.getText());
        this.m_refreshItem = VWStringUtils.getMenuItemUsingString(VWResource.s_refreshItem_withHK);
        this.m_refreshItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_refreshItem, this.m_fileMenu, this.m_refreshItem.getText(), this.m_refreshItem.getText());
        this.m_openTrackerItem = VWStringUtils.getMenuItemUsingString(VWResource.s_openTracker_withHK);
        this.m_openTrackerItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_openTrackerItem, this.m_fileMenu, this.m_openTrackerItem.getText(), this.m_openTrackerItem.getText());
        this.m_openStepProcessorItem = VWStringUtils.getMenuItemUsingString(VWResource.s_openStepProcessor_withHK);
        this.m_openStepProcessorItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_openStepProcessorItem, this.m_fileMenu, this.m_openStepProcessorItem.getText(), this.m_openStepProcessorItem.getText());
        this.m_pageSetupItem = VWStringUtils.getMenuItemUsingString(VWResource.s_pageSetup_withHK);
        this.m_pageSetupItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_pageSetupItem, this.m_fileMenu, this.m_pageSetupItem.getText(), this.m_pageSetupItem.getText());
        this.m_printItem = VWStringUtils.getMenuItemUsingString(VWResource.s_print_withHK);
        this.m_printItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_printItem, this.m_fileMenu, this.m_printItem.getText(), this.m_printItem.getText());
        this.m_exportItem = VWStringUtils.getMenuItemUsingString(VWResource.s_exportMenu_withHK);
        this.m_exportItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_exportItem, this.m_fileMenu, this.m_exportItem.getText(), this.m_exportItem.getText());
        this.m_exitItem = VWStringUtils.getMenuItemUsingString(VWResource.s_exit_withHK);
        this.m_exitItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_exitItem, this.m_fileMenu, this.m_exitItem.getText(), this.m_exitItem.getText());
    }

    private void initEditMenuItems() {
        this.m_editMenu = VWStringUtils.getMenuUsingString(VWResource.s_editMenu_withHK);
        VWAccessibilityHelper.setAccessibility(this.m_editMenu, this.m_menuBar, this.m_editMenu.getText(), this.m_editMenu.getText());
        this.m_fieldValuesItem = VWStringUtils.getMenuItemUsingString(VWResource.s_fieldValues_withHK);
        this.m_fieldValuesItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_fieldValuesItem, this.m_editMenu, this.m_fieldValuesItem.getText(), this.m_fieldValuesItem.getText());
        this.m_findNowItem = VWStringUtils.getMenuItemUsingString(VWResource.s_findNow_withHK);
        this.m_findNowItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_findNowItem, this.m_editMenu, this.m_findNowItem.getText(), this.m_findNowItem.getText());
        this.m_newSearchItem = VWStringUtils.getMenuItemUsingString(VWResource.s_newSearch_withHK);
        this.m_newSearchItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_newSearchItem, this.m_editMenu, this.m_newSearchItem.getText(), this.m_newSearchItem.getText());
    }

    private void initViewMenuItems() {
        this.m_viewMenu = VWStringUtils.getMenuUsingString(VWResource.s_viewMenu_withHK);
        VWAccessibilityHelper.setAccessibility(this.m_viewMenu, this.m_menuBar, this.m_viewMenu.getText(), this.m_viewMenu.getText());
        this.m_searchPaneItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_searchPane_withHK);
        this.m_searchPaneItem.setSelected(true);
        this.m_searchPaneItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_searchPaneItem, this.m_viewMenu, this.m_searchPaneItem.getText(), this.m_searchPaneItem.getText());
        this.m_resultsPaneItem = VWStringUtils.getCheckBoxMenuItemUsingString(VWResource.s_resultsPane_withHK);
        this.m_resultsPaneItem.setSelected(true);
        this.m_resultsPaneItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_resultsPaneItem, this.m_viewMenu, this.m_resultsPaneItem.getText(), this.m_resultsPaneItem.getText());
        this.m_nextSetItem = VWStringUtils.getMenuItemUsingString(VWResource.s_nextSet_withHK);
        this.m_nextSetItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_nextSetItem, this.m_viewMenu, this.m_nextSetItem.getText(), this.m_nextSetItem.getText());
        this.m_showHideColumnsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_showHideColumns_withHK);
        this.m_showHideColumnsItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_showHideColumnsItem, this.m_viewMenu, this.m_showHideColumnsItem.getText(), this.m_showHideColumnsItem.getText());
    }

    private void initTasksMenuItems() {
        this.m_tasksMenu = VWStringUtils.getMenuUsingString(VWResource.s_tasks_withHK);
        VWAccessibilityHelper.setAccessibility(this.m_tasksMenu, this.m_menuBar, this.m_tasksMenu.getText(), this.m_tasksMenu.getText());
        this.m_manageAttachmentsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_manageAttachments_withHK);
        this.m_manageAttachmentsItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_manageAttachmentsItem, this.m_tasksMenu, this.m_manageAttachmentsItem.getText(), this.m_manageAttachmentsItem.getText());
        this.m_manageWFGroupsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_manageWFGroups_withHK);
        this.m_manageWFGroupsItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_manageWFGroupsItem, this.m_tasksMenu, this.m_manageWFGroupsItem.getText(), this.m_manageWFGroupsItem.getText());
        this.m_manageTrackersItem = VWStringUtils.getMenuItemUsingString(VWResource.s_manageTrackers_withHK);
        this.m_manageTrackersItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_manageTrackersItem, this.m_tasksMenu, this.m_manageTrackersItem.getText(), this.m_manageTrackersItem.getText());
        this.m_assignReassignWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_assignReassignWork_withHK);
        this.m_assignReassignWorkItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_assignReassignWorkItem, this.m_tasksMenu, this.m_assignReassignWorkItem.getText(), this.m_assignReassignWorkItem.getText());
        this.m_returnWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_returnWork_withHK);
        this.m_returnWorkItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_returnWorkItem, this.m_tasksMenu, this.m_returnWorkItem.getText(), this.m_returnWorkItem.getText());
        this.m_completeWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_completeWork_withHK);
        this.m_completeWorkItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_completeWorkItem, this.m_tasksMenu, this.m_completeWorkItem.getText(), this.m_completeWorkItem.getText());
        this.m_deleteWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_deleteWork_withHK);
        this.m_deleteWorkItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_deleteWorkItem, this.m_tasksMenu, this.m_deleteWorkItem.getText(), this.m_deleteWorkItem.getText());
        this.m_terminateWorkItem = VWStringUtils.getMenuItemUsingString(VWResource.s_terminateWork_withHK);
        this.m_terminateWorkItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_terminateWorkItem, this.m_tasksMenu, this.m_terminateWorkItem.getText(), this.m_terminateWorkItem.getText());
        this.m_recoveryItem = VWStringUtils.getMenuItemUsingString(VWResource.s_recoverUsers_withHK);
        this.m_recoveryItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_recoveryItem, this.m_tasksMenu, this.m_recoveryItem.getText(), this.m_recoveryItem.getText());
        this.m_outOfOfficeItem = VWStringUtils.getMenuItemUsingString(VWResource.s_outOfOffice_withHK);
        this.m_outOfOfficeItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_outOfOfficeItem, this.m_tasksMenu, this.m_outOfOfficeItem.getText(), this.m_outOfOfficeItem.getText());
    }

    private void initHelpMenuItems() {
        this.m_helpMenu = VWStringUtils.getMenuUsingString(VWResource.s_helpMenu_withHK);
        VWAccessibilityHelper.setAccessibility(this.m_helpMenu, this.m_menuBar, this.m_helpMenu.getText(), this.m_helpMenu.getText());
        this.m_contentsItem = VWStringUtils.getMenuItemUsingString(VWResource.s_contentsAndIndex_withHK);
        this.m_contentsItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_contentsItem, this.m_helpMenu, this.m_contentsItem.getText(), this.m_contentsItem.getText());
        this.m_aboutItem = VWStringUtils.getMenuItemUsingString(VWResource.s_about_withHK);
        this.m_aboutItem.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_aboutItem, this.m_helpMenu, this.m_aboutItem.getText(), this.m_aboutItem.getText());
    }

    private void initFileMenu() {
        if (this.m_fileMenu == null) {
            return;
        }
        this.m_fileMenu.removeAll();
        this.m_fileMenu.add(this.m_lockItem);
        this.m_fileMenu.add(this.m_unlockItem);
        this.m_fileMenu.add(this.m_unlockAllItem);
        this.m_fileMenu.add(this.m_saveItem);
        this.m_fileMenu.add(this.m_saveAllItem);
        this.m_fileMenu.add(this.m_discardItem);
        this.m_fileMenu.add(this.m_discardAllItem);
        this.m_fileMenu.add(new JSeparator());
        this.m_fileMenu.add(this.m_openTrackerItem);
        this.m_fileMenu.add(this.m_openStepProcessorItem);
        this.m_fileMenu.add(new JSeparator());
        this.m_fileMenu.add(this.m_pageSetupItem);
        this.m_fileMenu.add(this.m_printItem);
        this.m_fileMenu.add(this.m_exportItem);
        this.m_fileMenu.add(new JSeparator());
        this.m_fileMenu.add(this.m_exitItem);
    }

    private void initEditMenu() {
        if (this.m_editMenu == null) {
            return;
        }
        this.m_editMenu.removeAll();
        this.m_editMenu.add(this.m_fieldValuesItem);
        this.m_editMenu.add(new JSeparator());
        this.m_editMenu.add(this.m_findNowItem);
        this.m_editMenu.add(this.m_newSearchItem);
    }

    private void initViewMenu() {
        if (this.m_viewMenu == null) {
            return;
        }
        this.m_viewMenu.removeAll();
        this.m_viewMenu.add(this.m_searchPaneItem);
        this.m_viewMenu.add(this.m_resultsPaneItem);
        this.m_viewMenu.add(new JSeparator());
        this.m_viewMenu.add(this.m_infoStackItem);
        this.m_viewMenu.add(new JSeparator());
        this.m_viewMenu.add(this.m_refreshItem);
        this.m_viewMenu.add(new JSeparator());
        this.m_viewMenu.add(this.m_nextSetItem);
        this.m_viewMenu.add(new JSeparator());
        this.m_viewMenu.add(this.m_showHideColumnsItem);
    }

    private void initTasksMenu() {
        if (this.m_tasksMenu == null) {
            return;
        }
        this.m_tasksMenu.removeAll();
        this.m_tasksMenu.add(this.m_manageWFGroupsItem);
        this.m_tasksMenu.add(this.m_manageTrackersItem);
        this.m_tasksMenu.add(new JSeparator());
        this.m_tasksMenu.add(this.m_assignReassignWorkItem);
        this.m_tasksMenu.add(this.m_completeWorkItem);
        this.m_tasksMenu.add(this.m_deleteWorkItem);
        this.m_tasksMenu.add(this.m_terminateWorkItem);
        this.m_tasksMenu.add(new JSeparator());
        this.m_tasksMenu.add(this.m_recoveryItem);
        this.m_tasksMenu.add(this.m_outOfOfficeItem);
    }

    private void initHelpMenu() {
        if (this.m_helpMenu == null) {
            return;
        }
        this.m_helpMenu.removeAll();
        this.m_helpMenu.add(this.m_contentsItem);
        this.m_helpMenu.add(this.m_aboutItem);
    }

    private void performExitItemAction(boolean bCloseWindow) {
        try {
            if (!this.exitApp()) {
                return;
            }
            if (!bCloseWindow) {
                return;
            }
            Container parentContainer = this.m_vwSessionInfo.getParentContainer();
            if (parentContainer != null && parentContainer instanceof JFrame) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)parentContainer, 201));
            } else if (parentContainer != null && parentContainer instanceof VWBaseAppLauncherApplet) {
                ((VWBaseAppLauncherApplet)parentContainer).closeWindow();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performViewSearchPaneAction() {
        if (this.m_searchPaneItem.isSelected()) {
            this.m_resultsPaneItem.setEnabled(true);
            if (this.m_resultsPaneItem.isSelected()) {
                this.m_rootSplitPane.setDividerLocation(this.m_iDividerLocation);
            } else {
                this.m_rootSplitPane.setDividerLocation(0.99);
            }
        } else {
            this.m_resultsPaneItem.setEnabled(false);
            if (this.m_resultsPaneItem.isSelected()) {
                this.m_rootSplitPane.setDividerLocation(0.0);
            }
        }
    }

    private void performViewResultsPaneAction() {
        if (this.m_resultsPaneItem.isSelected()) {
            this.m_searchPaneItem.setEnabled(true);
            if (this.m_searchPaneItem.isSelected()) {
                this.m_rootSplitPane.setDividerLocation(this.m_iDividerLocation);
            } else {
                this.m_rootSplitPane.setDividerLocation(0.0);
            }
        } else {
            this.m_searchPaneItem.setEnabled(false);
            if (this.m_searchPaneItem.isSelected()) {
                this.m_rootSplitPane.setDividerLocation(0.99);
            }
        }
    }

    private void performAboutItemAction() {
        try {
            ImageIcon icon = VWImageLoader.createImageIcon("admin_ico.gif");
            String productName = VWIDMBaseFactory.instance().getVWString(3).toString();
            VWAboutHelper aboutBox = new VWAboutHelper(this.m_vwSessionInfo.getParentFrame(), productName, icon, this.m_vwSessionInfo);
            aboutBox.display();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performContentsItemAction() {
        VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah014.htm");
    }
}

